package simulator;

import java.util.Set;

import service.ComposedTransition;
import service.ComposedState;
import service.SimpleTransition;
import service.SimpleState;
import service.State;
import service.TransitionSystem;

public abstract class Simulation {
	
	/**
	 * Used to instantiate the simulation.
	 * Only used in subclasses.
	 */
	protected Simulation(){}
	
	/**
	 * Returns a Set of Composed State similar to the given one.
	 * @param targetState the target state which is interesting to know the similar state
	 * @return A set of Composed State similar to the given one.
	 */
	public abstract Set<ComposedState> getSimilarStates(State targetState);
	
	/**
	 * Returns the target service transition system.
	 * @return the target service transition system
	 */
	public abstract TransitionSystem<SimpleState, SimpleTransition> getTargetTs();
	
	/**
	 * Returns the transition system of the composition deriving from the computation of the simulation.
	 * @return the transition system of the composition.
	 */
	public abstract TransitionSystem<ComposedState, ComposedTransition> getCompositionTs();
	
	/**
	 * Returns all couples of state that are in the simulation relation.
	 * The first state of the couple (array of 2 elements) is the state of the target service.
	 * The second state of the couple is the composed state that simulates the first state.
	 * @return a set of couples (arrays of 2 elements) that are in the simulation relation.
	 */
	public abstract Set<State[]> getAllSimilarState();
	
	/**
	 * Method that returns the transition system representing the asynchronous product of the available
	 * services transitions systems.
	 * @return the transition system representing the asynchronous product.
	 */
	public abstract TransitionSystem<ComposedState, ComposedTransition> getAsyncProduct();
}
